"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.writeArtifactJson = exports.writeArtifactData = void 0;
const subjectJson = [];
/* Format the subject data
 * @subjectData: Map of artifact name and sha256 digest
 */
function writeArtifactData(subjectData) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            // Iterate through the subjectData
            subjectData.forEach((hash, subject) => 
            // Write the subject data
            subjectJson.push({ name: subject, digest: { sha256: hash } }));
            return subjectJson;
        }
        catch (err) {
            throw new Error('writeArtifactData: ' + err);
        }
    });
}
exports.writeArtifactData = writeArtifactData;
function writeArtifactJson(subjectJson, builderId, buildInvocationId, materialsUri, buildSourceVersion, buildDefinitionName) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            const buildJson = {
                "_type": "https://in-toto.io/Statement/v0.1",
                "subject": subjectJson,
                "predicateType": "https://slsa.dev/provenance/v0.1",
                "predicate": {
                    "builder": {
                        "id": builderId
                    },
                    "metadata": {
                        "buildInvocationId": buildInvocationId,
                        "completeness": {
                            "arguments": true,
                            "environment": false,
                            "materials": false
                        },
                        "reproducible": false,
                        "buildFinishedOn": new Date()
                    },
                    "recipe": {
                        "type": "https://dev.azure.com/Attestations/SLSAProvenanceGenerator@0",
                        "definedInMaterial": 0,
                        "entryPoint": buildDefinitionName,
                        "arguments": null,
                        "environment": null
                    },
                    "materials": [
                        {
                            "uri": materialsUri,
                            "digest": {
                                "sha1": buildSourceVersion
                            }
                        }
                    ]
                }
            };
            const json = JSON.stringify(buildJson, null, 4);
            return json;
        }
        catch (err) {
            throw new Error('writeArtifactJson: ' + err);
        }
    });
}
exports.writeArtifactJson = writeArtifactJson;
