"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const tl = require("azure-pipelines-task-lib");
const wp = __importStar(require("./writeprovenance"));
const crypto = __importStar(require("crypto"));
const fs = __importStar(require("fs"));
const path = __importStar(require("path"));
// Array for storing list of artifacts to hash
let arrayOfFiles;
// Create dictionary type for artifact and digest to be used to populate the subject
const subjectData = new Map();
/**
 * Get Agent.TempDirectory which is a temp folder that is cleaned after each pipeline job.
 * This is where we will store the build.provenance output file.
 */
const tempPath = tl.getVariable('Agent.TempDirectory');
function run() {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            tl.setResourcePath(path.join(__dirname, 'task.json'));
            // Get path to artifact
            const artifactPath = tl.getInput('artifactPath', true); // eslint-disable-line @typescript-eslint/no-non-null-assertion
            // ADO documentation on pre-defined variables for Azure Pipelines
            // https://docs.microsoft.com/en-us/azure/devops/pipelines/build/variables
            // https://docs.microsoft.com/en-us/azure/devops/pipelines/process/run-number
            const buildId = tl.getVariable('Build.BuildId');
            const buildDefinitionName = tl.getVariable('Build.DefinitionName');
            const buildSourceVersion = tl.getVariable('Build.SourceVersion');
            const buildRepositoryProvider = tl.getVariable('Build.Repository.Provider');
            const buildRepositoryUri = tl.getVariable('Build.Repository.Uri');
            const teamFoundationCollectionUri = tl.getVariable('System.TeamFoundationCollectionUri');
            const teamProject = tl.getVariable('System.TeamProject');
            // Determine the SPDX Download Location
            // https://spdx.github.io/spdx-spec/3-package-information/#37-package-download-location
            let vcsType = '';
            if (buildRepositoryProvider === 'Git' || buildRepositoryProvider === 'GitHub' || buildRepositoryProvider === 'TfsGit') {
                vcsType = 'git+https';
            }
            else if (buildRepositoryProvider === 'TfsVersionControl') {
                vcsType = 'tfvc+https';
            }
            else if (buildRepositoryProvider === 'Svn') {
                vcsType = 'svn+https';
            }
            else {
                // 
                tl.setResult(tl.TaskResult.Failed, (`${buildRepositoryUri}: VCS type unknown, expecting: git, svn, or tfvc.`));
            }
            // Prepare the artifact data
            const artifactSubjectData = yield prepareSubjectData(artifactPath);
            const foo = yield wp.writeArtifactData(artifactSubjectData);
            const builderId = (`${teamFoundationCollectionUri}${teamProject}/Attestations`);
            const buildInvocationId = (`${teamFoundationCollectionUri}${teamProject}/_build/${buildId}`);
            const materialsUri = (`${vcsType}+${buildRepositoryUri}`);
            const createJson = yield wp.writeArtifactJson(foo, builderId, buildInvocationId, materialsUri, buildSourceVersion, buildDefinitionName);
            console.log(createJson);
            try {
                /* eslint-disable-next-line security/detect-non-literal-fs-filename -- Safe as no value holds user input */
                fs.writeFile(path.join(tempPath + '/build.provenance'), createJson, (err) => {
                    if (!err) {
                        console.log('done');
                    }
                });
            }
            catch (err) {
                throw new Error(err);
            }
            console.log('##vso[artifact.upload containerfolder=SLSALevel1;artifactname=build.provenance]' + (path.join(tempPath + '/build.provenance')));
            tl.setResult(tl.TaskResult.Succeeded, "Job succeeded.");
        }
        catch (err) {
            tl.setResult(tl.TaskResult.Failed, err.message);
        }
    });
}
/*
 * Prepare artifact data by creating a key/value dictionary of artifact name and sha256 digest.
 * @artifactPath: User supplied input
 */
function prepareSubjectData(artifactPath) {
    return __awaiter(this, void 0, void 0, function* () {
        let subject = new Map();
        try {
            // Validate artifactPath exists
            if (tl.exist(artifactPath)) {
                // Check to see if the artifactPath is a file
                const file = yield is_file(artifactPath);
                if (file) {
                    // This is where i will call out to the functionality
                    // that will itemize and hash the file
                    tl.debug('prepareSubjectData: ' + `${artifactPath}` + ' is a single artifact.');
                    subject = yield buildSubjectData(artifactPath);
                    return subject;
                }
                else {
                    // The artifactPath was a folder, which means we have
                    // to iterate through everything in it and build a BOM.
                    // TODO: recursively search the path given if additional folders exist
                    tl.debug('prepareSubjectData: ' + `${artifactPath}` + ' contains multiple artifacts.');
                    try {
                        arrayOfFiles = fs.readdirSync(artifactPath);
                    }
                    catch (err) {
                        console.log('prepareSubjectData: ' + err);
                    }
                    for (const item of arrayOfFiles) {
                        // Get path to file
                        const pathToFile = path.resolve(artifactPath, item);
                        const file = yield is_file(pathToFile);
                        if (file) {
                            subject = yield buildSubjectData(pathToFile);
                        }
                    }
                    return subject;
                }
            }
            else {
                // A bad file or directory was supplied
                throw new Error('prepareSubjectData: Invalid Artifact path.');
            }
        }
        catch (err) {
            throw new Error('prepareSubjectData: ' + err);
        }
    });
}
/*
 * Check to see if supplied object is a file
 * @fileCandidate: string
 */
function is_file(fileCandidate) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            /* eslint-disable-next-line security/detect-non-literal-fs-filename -- Safe as we are checking if it is a file or not */
            const stats = fs.statSync(fileCandidate);
            return stats.isFile();
        }
        catch (err) {
            throw new Error('is_file: ' + err);
        }
    });
}
/*
 * Build name and hash map of the artifacts
 * @artifact: string
 */
function buildSubjectData(artifact) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            // Read the data from the artifact
            /* eslint-disable-next-line security/detect-non-literal-fs-filename -- Safe as the file contents are hashed and not returned to the user */
            const fileBuffer = fs.readFileSync(artifact);
            // Hash the data
            const artifactHash = crypto.createHash('sha256');
            artifactHash.update(fileBuffer);
            // Extract the filename from its UNC path
            const artifactName = path.basename(artifact);
            // Populate the results
            subjectData.set(artifactName, artifactHash.digest('hex'));
            return subjectData;
        }
        catch (err) {
            throw new Error('buildSubjectData: ' + err);
        }
    });
}
run();
